import { world, GameMode, EquipmentSlot } from "@minecraft/server";
import { HAMMER_IDENTIFIER } from "./Hammer.js";

export function Durability(player, item, damageAmount = 1) {
    if (!player || !item || !HAMMER_IDENTIFIER.includes(item.typeId) || player.getGameMode() === GameMode.creative) {
        return;
    }

    const durabilityComponent = item.getComponent('durability');
    if (!durabilityComponent) {
        return;
    }

    const enchantmentComponent = item.getComponent('enchantable');
    const unbreakingLevel = enchantmentComponent?.getEnchantment('unbreaking')?.level ?? 0;

    let actualDamage = 0;
    for (let i = 0; i < damageAmount; i++) {
        if (unbreakingLevel > 0) {
            const chanceToNotTakeDamage = unbreakingLevel / (unbreakingLevel + 1);
            if (Math.random() < chanceToNotTakeDamage) {
                continue;
            }
        }
        actualDamage++;
    }

    if (actualDamage > 0) {
        const newDamage = Math.min(durabilityComponent.damage + actualDamage, durabilityComponent.maxDurability);
        durabilityComponent.damage = newDamage;

        if (newDamage >= durabilityComponent.maxDurability) {
            player.getComponent('equippable').setEquipment(EquipmentSlot.Mainhand, undefined);
            player.playSound('random.break');
        } else {
            player.getComponent('equippable').setEquipment(EquipmentSlot.Mainhand, item);
        }
    }
}

export function testDurability(player, item, iterations = 100) {
    for (let i = 0; i < iterations; i++) {
        Durability(player, item, 1);
    }
}

export function giveNewHammer(player, hammerType = "wave:hammer") {
    if (!HAMMER_IDENTIFIER.includes(hammerType)) {
        console.error("Invalid hammer type");
        return;
    }

    const hammer = player.dimension.spawnItem({
        item: { id: hammerType, amount: 1 },
        location: player.location
    });

    if (hammer) {
        const durabilityComponent = hammer.getComponent("durability");
        if (durabilityComponent) {
            durabilityComponent.damage = 0;
        }
    }
}