import { ItemStack } from "@minecraft/server";

const oreDrops = new Map([
    ['minecraft:coal_ore', { item: 'minecraft:coal', multiplier: 1 }],
    ['minecraft:deepslate_coal_ore', { item: 'minecraft:coal', multiplier: 1 }],
    ['minecraft:diamond_ore', { item: 'minecraft:diamond', multiplier: 1 }],
    ['minecraft:deepslate_diamond_ore', { item: 'minecraft:diamond', multiplier: 1 }],
    ['minecraft:emerald_ore', { item: 'minecraft:emerald', multiplier: 1 }],
    ['minecraft:deepslate_emerald_ore', { item: 'minecraft:emerald', multiplier: 1 }],
    ['minecraft:lapis_ore', { item: 'minecraft:lapis_lazuli', multiplier: 4 }],
    ['minecraft:deepslate_lapis_ore', { item: 'minecraft:lapis_lazuli', multiplier: 4 }],
    ['minecraft:redstone_ore', { item: 'minecraft:redstone', multiplier: 4 }],
    ['minecraft:deepslate_redstone_ore', { item: 'minecraft:redstone', multiplier: 4 }],
    ['minecraft:nether_gold_ore', { item: 'minecraft:gold_nugget', multiplier: 2 }],
    ['minecraft:nether_quartz_ore', { item: 'minecraft:quartz', multiplier: 1 }],
    ['minecraft:iron_ore', { item: 'minecraft:raw_iron', multiplier: 1 }],
    ['minecraft:deepslate_iron_ore', { item: 'minecraft:raw_iron', multiplier: 1 }],
    ['minecraft:copper_ore', { item: 'minecraft:raw_copper', multiplier: 1 }],
    ['minecraft:deepslate_copper_ore', { item: 'minecraft:raw_copper', multiplier: 1 }],
    ['minecraft:gold_ore', { item: 'minecraft:raw_gold', multiplier: 1 }],
    ['minecraft:deepslate_gold_ore', { item: 'minecraft:raw_gold', multiplier: 1 }],
    ['minecraft:amethyst_cluster', { item: 'minecraft:amethyst_shard', multiplier: 2 }],
 
]);

export function getFortuneExtraDrops(block, fortuneLevel) {
    const extraDrops = [];
    const dropInfo = oreDrops.get(block.typeId);

    if (dropInfo) {
        const { item, multiplier } = dropInfo;
        const baseChance = 2 / (fortuneLevel + 2);
        const random = Math.random();
        let drops
        if (random < baseChance) {
            drops = 1;
        } else {
            const bonusDrops = Math.floor(Math.random() * fortuneLevel) + 1;
            drops = bonusDrops + 1;
        }

        drops *= multiplier;

        for (let i = multiplier; i < drops; i++) {
            extraDrops.push(new ItemStack(item, 1));
        }
    }

    return extraDrops;
}