import { world, system, MinecraftDimensionTypes } from "@minecraft/server";

export const NETHERITE_HAMMER_ID = "hammertool:netherite_hammer";

export function NetheriteHammer(item) {
    return item && item.typeId === NETHERITE_HAMMER_ID;
}

export function LavaResistance() {
    const dimensions = [MinecraftDimensionTypes.overworld, MinecraftDimensionTypes.nether, MinecraftDimensionTypes.theEnd];

    system.runInterval(() => {
        dimensions.forEach(dimensionId => Burning(dimensionId));
    }, 0);
}

function Burning(dimensionId) {
    const dimension = world.getDimension(dimensionId);

    for (const item of dimension.getEntities({ type: "minecraft:item" })) {
        const itemStack = item.getComponent("item").itemStack;
        if (NetheriteHammer(itemStack)) {
            item.triggerEvent("lava");
        }
    }
}