import { ItemEnchantableComponent, ItemStack } from "@minecraft/server";
import { getFortuneExtraDrops } from "./OreBreaking.js";

export function Enchantment(item) {
    if (!item) return null;

    const enchantments = item.getComponent(ItemEnchantableComponent.componentId);
    if (!enchantments) return null;

    return {
        hasEnchantment: (enchantmentId) => enchantments.hasEnchantment(enchantmentId),
        getEnchantment: (enchantmentId) => enchantments.getEnchantment(enchantmentId),
    };
}

export async function breakBlockWithSilkTouch(player, block, position) {
    const blockTypeId = block.typeId;
    if (blockTypeId) {
        await player.runCommandAsync(`setblock ${position.x} ${position.y} ${position.z} air replace`);
        player.dimension.spawnItem(new ItemStack(blockTypeId, 1), position);
        player.playSound("dig." + blockTypeId.split(":")[1], { location: position, volume: 1.0, pitch: 1.0 });
    }
}

export async function breakBlockWithFortune(player, block, position, fortuneLevel) {
    const extraDrops = getFortuneExtraDrops(block, fortuneLevel);
    await player.runCommandAsync(`setblock ${position.x} ${position.y} ${position.z} air destroy`);
    for (const drop of extraDrops) {
        player.dimension.spawnItem(drop, position);
    }
}

export function checkHammerEnchantments(item) {
    const enchantments = Enchantment(item);
    if (!enchantments) return { hasSilkTouch: false, fortuneLevel: 0 };

    const hasSilkTouch = enchantments.hasEnchantment('silk_touch');
    const fortuneLevel = enchantments.getEnchantment('fortune')?.level || 0;

    return { hasSilkTouch, fortuneLevel };
}