//f6e2b071-f3f9-431c-91a6-7855d8190374 bp publish (0.0.2)
//9d98b01e-ebd4-46c6-9602-dbf0ca3c9179 rp publish (0.0.2)
//00a83e56-7ae4-49a9-96c3-2358a8f56150 bp development (0.0.11)
//cab2d426-2bc6-4e84-8e49-bcfd226911b6 rp development (0.0.1)
import * as MC from '@minecraft/server';
import * as MCUI from '@minecraft/server-ui';
const MDS = '§';

//Data APIs
let internalData = {
    'playersInUI': {}
};
const inDapi = {
    'get': function inDapiGet(key) { return internalData[key]; },
    'set': function inDapiSet(key, value) { internalData[key] = value; }
}
const mcDapi = {
    'get': function mcDapiGet(holder, key) {
        let result = holder.getDynamicProperty(key);
        if (result === undefined) { return result; }
        else { return JSON.parse(result); };
    },
    'set': function mcDapiSet(holder, key, value) { holder.setDynamicProperty(key, JSON.stringify(value)); }
};

let allSaveDataKeys = MC.world.getDynamicPropertyIds();
allSaveDataKeys.forEach(key => {
    if (key.startsWith('noteworks:') === true) {
        inDapi.set(key, mcDapi.get(MC.world, key));
    };
});



//Play disc
function playDisc(dimension, location, notes, player = undefined) {
    if (player === undefined) { player = '@a'; }
    else { player = `@a[name="${player.name}"]` };
    dimension = MC.world.getDimension(dimension);
    for (let i = 0; i < notes.length; i++) {
        let note = notes[i];
        if (note === 0 || note === null) { continue; };
        MC.system.runTimeout(() => {
            try { dimension.runCommand(`playsound ${note.t} ${player} ${location.x} ${location.y} ${location.z} ${note.v} ${note.p}`); }
            catch { };
        }, i);
    };
};
//Convert number to color string
function discColor(number) {
    let colors = {
        '0': '',
        '1': '_black',
        '2': '_white',
        '3': '_blue',
        '4': '_cyan',
        '5': '_sky',
        '6': '_lime',
        '7': '_green',
        '8': '_brown',
        '9': '_orange',
        '10': '_yellow',
        '11': '_red',
        '12': '_purple',
        '13': '_magenta',
        '14': '_pink'
    };
    return colors[`${number}`];
};
//Create new disc item
function newDisc(data = undefined) {
    if (data === undefined) {
        data = {
            'v': 1,
            'color': 0,
            'author': 'None',
            'name': 'Disc',
            'desc': 'None',
            'runtime': 1,
            'locked': false,
            'notes': []
        };
    };
    let item = undefined;
    if (data.color === undefined || data.color === 0) { item = new MC.ItemStack('noteworks:disc'); }
    else { item = new MC.ItemStack(`noteworks:disc${discColor(data.color)}`); };
    item.nameTag = data.name;
    mcDapi.set(item, 'noteworks:discData', data);
    item.setLore([`${MDS}7${data.author} ${MDS}r${MDS}7- ${data.name}`]);
    return item;
};
//Update disc format
function updateDisc(item, discData) {
    if (item.typeId.startsWith('noteworks:disc')) {
        if (discData !== undefined) {
            let version = discData.v;
            if (version === undefined) {
                discData.color = 0;
                discData.v = 1;
                mcDapi.set(item, 'noteworks:discData', discData);
            };
        };
    }
    return item;
}




const MODALS = {
    'newDisc': function (player, item) {
        let modal = new MCUI.ModalFormData()
            .title('Initialize Disc')
            .dropdown(`Color`, ['Gray', 'Black', 'White', 'Blue', 'Cyan', 'Sky', 'Lime', 'Green', 'Brown', 'Orange', 'Yellow', 'Red', 'Purple', 'Magenta', 'Pink'], 0)
            .textField(`${MDS}uAuthor\n${MDS}rLeave empty for true author.`, '', '')
            .textField(`${MDS}uName`, '', '')
            .textField(`${MDS}uDescription`, '', '')
            .slider('Run time (seconds)', 1, 60, 1, 1)
        modal.show(player).then(response => {
            if (response.canceled === true) { return; };
            let discAuthor = response.formValues[1].replaceAll(`${MDS}`, '');
            if (discAuthor.length === 0) { discAuthor = `${MDS}l${player.name}`; };
            let discName = response.formValues[2];
            if (discName.length === 0) { discName = 'None'; };
            let discDesc = response.formValues[3];
            if (discDesc.length === 0) { discDesc = `None`; };
            let discData = {
                'v': 1,
                'color': response.formValues[0],
                'author': discAuthor,
                'name': discName,
                'desc': discDesc,
                'locked': false,
                'runtime': response.formValues[4],
                'notes': []
            };
            let totalNotes = (discData.runtime * 20)
            for (let i = 0; i <= totalNotes; i++) {
                discData.notes.push(0);
            };
            item.setItem(newDisc(discData));
        });
    },
    'discOptions': function (player, item) {
        let modal = new MCUI.ActionFormData()
            .title('Disc Options')
            .button(`${MDS}lPlay track\n${MDS}rOnly you can hear this.`, 'textures/icons/play_track')
            .button(`${MDS}lTrack editor${MDS}r`, 'textures/icons/track_editor')
            .button(`${MDS}lTrack visualizer${MDS}r`, 'textures/icons/track_editor')
            .button(`${MDS}lEdit inscription${MDS}r`, 'textures/icons/inscription')
            .button(`${MDS}lCopy${MDS}r\nClone all data to another disc.`, 'textures/icons/add')
            .button(`${MDS}lScrub${MDS}r\nDelete all data on this disc.`, 'textures/icons/reset')
            .button(`${MDS}lLock${MDS}r\nForever lock this disc.`, 'textures/icons/lock');
        modal.show(player).then(response => {
            if (response.canceled === true) { return; };
            if (response.selection === 0) {
                let discData = mcDapi.get(item, 'noteworks:discData');
                playDisc(player.dimension.id, player.location, discData.notes, player);
            }
            else if (response.selection === 1) {
                MODALS.trackEditor(player, item);
            }
            else if (response.selection === 2) {
                MODALS.trackVisualizer(player, item);
            }
            else if (response.selection === 3) {
                MODALS.inscriptionEditor(player, item);
            }
            else if (response.selection === 4) {
                let emptyDisc = undefined;
                let inventory = player.getComponent('minecraft:inventory');
                for (let i = 0; i < inventory.container.size; i++) {
                    try {
                        let stack = inventory.container.getSlot(i);
                        if (stack.typeId.startsWith('noteworks:disc') === true) {
                            let discData = mcDapi.get(stack, 'noteworks:discData');
                            if (discData === undefined) {
                                emptyDisc = stack;
                            };
                        };
                    } catch { };
                };
                if (emptyDisc === undefined) {
                    player.sendMessage(`${MDS}cYou need an empty disc to copy to.`);
                }
                else {
                    let discData = mcDapi.get(item, 'noteworks:discData');
                    emptyDisc.setItem(newDisc(discData));
                };
            }
            else if (response.selection === 5) {
                item.setItem(new MC.ItemStack('noteworks:disc'));
            }
            else if (response.selection === 6) {
                let discData = mcDapi.get(item, 'noteworks:discData');
                discData.locked = true;
                mcDapi.set(item, 'noteworks:discData', discData);
                player.sendMessage(`${MDS}fThis disc is now ${MDS}cLocked${MDS}f. It can no longer be edited or played (from hand). To play this disc insert it into an Advanced Jukebox.`);
            }
        });
    },
    'inscriptionEditor': function (player, item) {
        let discData = mcDapi.get(item, 'noteworks:discData');
        let modal = new MCUI.ModalFormData()
            .title('Inscription Editor')
            .dropdown(`${MDS}uColor${MDS}r`, ['Gray', 'Black', 'White', 'Blue', 'Cyan', 'Sky', 'Lime', 'Green', 'Brown', 'Orange', 'Yellow', 'Red', 'Purple', 'Magenta', 'Pink'], discData.color)
            .textField(`${MDS}uAuthor${MDS}r\nLeave empty for true author.`, '', '')
            .textField(`${MDS}uName${MDS}r`, '', discData.name)
            .textField(`${MDS}uDescription${MDS}r`, '', discData.desc)
            .slider(`${MDS}uRun time (seconds)`, 1, 60, 1, discData.runtime);
        modal.show(player).then(response => {
            if (response.canceled === true) {
                MODALS.discOptions(player, item);
                return;
            };
            let discData = mcDapi.get(item, 'noteworks:discData');
            let discColor = response.formValues[0];
            let discAuthor = response.formValues[1].replaceAll(`${MDS}`, '');
            if (discAuthor.length === 0) { discAuthor = `${MDS}l${player.name}`; };
            let discName = response.formValues[2];
            if (discName.length === 0) { discName = 'Disc'; };
            let discDesc = response.formValues[3];
            if (discDesc.length === 0) { discDesc = `No Description`; };
            let discRuntime = response.formValues[4];
            discData.color = discColor;
            discData.author = discAuthor;
            discData.name = discName;
            discData.desc = discDesc;
            if (discData.runtime > discRuntime) {
                let difference = (discData.runtime - discRuntime) * 20;
                for (let i = 0; i < difference; i++) {
                    discData.notes.pop();
                };
            }
            else if (discData.runtime < discRuntime) {
                let difference = (discRuntime - discData.runtime) * 20;
                for (let i = 0; i < difference; i++) {
                    discData.notes.push(0);
                };
            };
            discData.runtime = discRuntime;
            item.setItem(newDisc(discData));
            MODALS.discOptions(player, item);
        });
    },
    'trackEditor': function (player, item, dNlS = 0, dNlSs = 0, dNt = 0, dMnt = '', dNV = 1, dNP = 1) {
        //dNlS = default note location (second)
        //dNlSs = default note location (sub-second)
        //dNt = default note type
        //dMnt = default manual note type
        //dNV = default note volume
        //dNP = default note pitch
        let discData = mcDapi.get(item, 'noteworks:discData');
        let modal = new MCUI.ModalFormData()
            .title('Track Editor')
            .slider(`${MDS}uNote location (second) ${MDS}f`, 0, discData.runtime, 1, dNlS)
            .slider(`${MDS}uNote location (sub-second) ${MDS}f`, 0, 19, 1, dNlSs)
            .dropdown(`${MDS}uNote type ${MDS}f`, ['None', 'Click', 'Bd', 'Hat', 'Bit', 'Pling', 'Bass', 'Bassattack', 'Guitar', 'Banjo', 'Harp', 'Flute', 'Chime', 'Bell', 'Cow bell', 'Xylophone', 'Iron xylophone'], dNt)
            .textField(`${MDS}uManual note type \n${MDS}f(Overwrites note type dropdown)`, 'Any minecraft sound.', dMnt)
            .slider(`${MDS}uNote volume ${MDS}r`, 0.1, 1, 0.1, dNV)
            .slider(`${MDS}uNote pitch ${MDS}r`, 0.1, 5, 0.1, dNP);
        modal.show(player).then(response => {
            if (response.canceled === true) {
                MODALS.discOptions(player, item);
                return;
            };
            let noteLocSec = response.formValues[0];
            let noteLocSub = response.formValues[1];
            let rawNoteType = response.formValues[2];
            let rawManualNoteType = response.formValues[3];
            let noteType = undefined;
            if (response.formValues[3].length > 0) { noteType = rawManualNoteType; }
            else {
                noteType = rawNoteType;
                let noteMap = [
                    'None',
                    'random.click',
                    'note.bd',
                    'note.hat',
                    'note.bit',
                    'note.pling',
                    'note.bass',
                    'note.bassattack',
                    'note.guitar',
                    'note.banjo',
                    'note.harp',
                    'note.flute',
                    'note.chime',
                    'note.bell',
                    'note.cow_bell',
                    'note.xylophone',
                    'note.iron_xylophone'
                ];
                noteType = noteMap[noteType];
            };
            let newNote = {
                't': noteType,
                'v': `${response.formValues[4].toFixed(1)}`,
                'p': `${response.formValues[5].toFixed(1)}`
            };
            if (newNote.t === 'None') { newNote = 0; };
            let notePosition = (noteLocSec * 20) + noteLocSub;
            let discData = mcDapi.get(item, 'noteworks:discData');
            discData.notes[notePosition] = newNote;
            mcDapi.set(item, 'noteworks:discData', discData);
            if (noteLocSub < 19) { noteLocSub += 1; }
            else {
                if (noteLocSec < discData.runtime) {
                    noteLocSub = 0; noteLocSec += 1;
                };
            };
            MODALS.trackEditor(player, item, noteLocSec, noteLocSub, rawNoteType, rawManualNoteType);
        });
    },
    'trackVisualizer': function (player, item) {
        let discData = mcDapi.get(item, 'noteworks:discData');
        let trackVisuals = [];
        let visSec = 0;
        let visTick = 0;
        discData.notes.forEach(note => {
            if (note === 0) { }
            else {
                if (note.t === undefined) { note.t = '?'; };
                if (note.v === undefined) { note.v = '?'; };
                if (note.p === undefined) { note.p = '?'; };
                trackVisuals.push(`${MDS}e${visSec}:${visTick} ${MDS}9Type: ${MDS}f${note.t} ${MDS}9Volume: ${MDS}f${note.v} ${MDS}9Pitch: ${MDS}f${note.p}`);
            };
            visTick += 1;
            if (visTick >= 20) { visSec += 1; visTick = 0; };
        });
        let modal = new MCUI.MessageFormData()
            .title(`Track Visualizer`)
            .body(`${trackVisuals.join('\n')}`)
            .button1(`${MDS}lTrack Editor${MDS}r`)
            .button2(`${MDS}cBack${MDS}r`)
        modal.show(player).then(response => {
            if (response.canceled === true) { return; };
            if (response.selection === 0) {
                MODALS.trackEditor(player, item);
                return;
            }
            else if (response.selection === 1) {
                MODALS.discOptions(player, item);
                return;
            };
        });
    },
    'discInscription': function (player, item) {
        let discData = mcDapi.get(item, 'noteworks:discData');
        let modal = new MCUI.MessageFormData()
            .title(`Disc Inscription`)
            .body(`${MDS}l${MDS}eName: ${MDS}r${discData.name}\n${MDS}l${MDS}eAuthor: ${MDS}r${discData.author}\n\n${MDS}r${discData.desc}`)
            .button1(`Okay`)
            .button2(`${MDS}2How to play disc${MDS}r`)
        modal.show(player).then(response => {
            if (response.selection === 0) { return; };
            if (response.selection === 1) {
                player.sendMessage(`In order to play this disc you need to insert it into an Advanced Jukebox.`);
            };
        });
    },
    'jukeboxOptions': function (player, block, item) {
        let modal = new MCUI.ActionFormData()
            .title('Adv. Jukebox Options')
            .body(`Power with redstone to activate automatically.\n${MDS}cActivating many at the same time will cause lag.`)
            .button(`${MDS}lPlay disc${MDS}r\nManually activate jukebox.`)
            .button(`${MDS}lInsert/take disc${MDS}r`)
        modal.show(player).then(response => {
            let playersInUI = inDapi.get('playersInUI');
            playersInUI[`${player.name}`] = false;
            inDapi.set('playersInUI', playersInUI);
            if (response.canceled === true) { return; };
            let jukeboxKeys = inDapi.get('noteworks:jukeboxes');
            if (jukeboxKeys === undefined) { jukeboxKeys = { 'a': [] }; };
            let jukeData = inDapi.get(`noteworks:jukebox.${JSON.stringify(block.location)}`);
            if (jukeData === undefined || jukeData.definition === 0) {
                jukeData = {
                    'dimension': block.dimension.id,
                    'location': block.location,
                    'powered': false,
                    'disc': undefined
                }
            };
            jukeboxKeys.a.push(JSON.stringify(block.location));
            let discData = mcDapi.get(item, 'noteworks:discData');
            if (response.selection === 0) {
                if (jukeData.disc !== undefined) {
                    playDisc(jukeData.dimension, jukeData.location, jukeData.disc.notes);
                }
                else { player.sendMessage(`${MDS}cInsert a disc into the jukebox first.`); };
            }
            else if (response.selection === 1) {
                if (jukeData.disc !== undefined) {
                    MC.world.getDimension(jukeData.dimension).spawnItem(newDisc(jukeData.disc), jukeData.location);
                    jukeData.disc = undefined;
                }
                else {
                    jukeData.disc = discData;
                    if (discData !== undefined) { item.setItem(new MC.ItemStack('minecraft:air')); };
                };
            };
            inDapi.set('noteworks:jukeboxes', jukeboxKeys);
            inDapi.set(`noteworks:jukebox.${JSON.stringify(block.location)}`, jukeData);
        });
    }
};




// === Main Tick ===
let updateTimer = 0;
function mainTick() {
    updateTimer += 1

    let jukeboxKeys = inDapi.get('noteworks:jukeboxes');
    if (jukeboxKeys === undefined) { jukeboxKeys = { 'a': [] }; };
    let newJukeboxKeys = jukeboxKeys;
    let count = -1;
    //Go through each jukebox & update them.
    jukeboxKeys.a.forEach(key => {
        count += 1
        let jukebox = inDapi.get(`noteworks:jukebox.${key}`);
        if (jukebox === undefined || jukebox.definition === 0) {
            delete newJukeboxKeys.a[count];
            count -= 1;
            return;
        };
        let block = MC.world.getDimension(jukebox.dimension).getBlock(jukebox.location);
        //delete data for no longer existing jukeboxes
        if (block === undefined) {
            return;
        };
        if (block.typeId !== 'noteworks:advanced_jukebox') {
            inDapi.set(`noteworks:jukebox.${key}`, { 'definition': 0 });
            return;
        };
        //Play track if gets redstone signal
        if (block.getRedstonePower() > 0 && jukebox.powered !== true && jukebox.disc !== undefined) {
            jukebox.powered = true;
            playDisc(block.dimension.id, block.location, jukebox.disc.notes);
        }
        else if (block.getRedstonePower() === 0 && jukebox.powered !== false) { jukebox.powered = false; }
        else { return; };
        inDapi.set(`noteworks:jukebox.${key}`, jukebox);
    });
    //Every 5 seconds save data to world.
    if (updateTimer > 100) {
        Object.keys(internalData).forEach(key => {
            if (key.startsWith('noteworks:') === true) {
                mcDapi.set(MC.world, key, internalData[key]);
            };
        });
    };
    inDapi.set('noteworks:jukeboxes', newJukeboxKeys);
    MC.system.run(mainTick);
};



// === On Item Use ===
MC.world.afterEvents.itemUse.subscribe(event => {
    if (event.itemStack.typeId.startsWith('noteworks:disc') === true) {
        let inventory = event.source.getComponent('minecraft:inventory');
        let item = inventory.container.getSlot(event.source.selectedSlot);
        let blockInView = event.source.getBlockFromViewDirection({ maxDistance: 7 });
        let block = undefined;
        if (blockInView === undefined) { block = { 'typeId': 0 }; }
        else { block = blockInView.block; };
        if (block.typeId === 'noteworks:advanced_jukebox') { }
        else {
            let discData = mcDapi.get(item, 'noteworks:discData');
            item = updateDisc(item, discData);
            if (discData === undefined) {
                MODALS.newDisc(event.source, item);
            }
            else {
                if (discData.locked === false) {
                    MODALS.discOptions(event.source, item);
                }
                else if (discData.locked === true) {
                    MODALS.discInscription(event.source, item);
                };
            };
        };
    };
});

//=== On Player Use Block ===
MC.world.afterEvents.playerInteractWithBlock.subscribe(event => {
    let inventory = event.player.getComponent('minecraft:inventory');
    let item = inventory.container.getSlot(event.player.selectedSlot);
    if (event.block.typeId === 'noteworks:advanced_jukebox') {
        let playersInUI = inDapi.get('playersInUI');
        let isInUI = playersInUI[`${event.player.name}`];
        if (isInUI === undefined || isInUI === false) {
            playersInUI[`${event.player.name}`] = true;
            inDapi.set('playersInUI', playersInUI);
            MODALS.jukeboxOptions(event.player, event.block, item);
        };
    };
});

//=== On Player Break Block ===
MC.world.beforeEvents.playerBreakBlock.subscribe(event => {
    if (event.block.typeId === 'noteworks:advanced_jukebox') {
        let jukeData = inDapi.get(`noteworks:jukebox.${JSON.stringify(event.block.location)}`);
        if (jukeData !== undefined) {
            if (jukeData.disc !== undefined) {
                MC.system.run(() => { event.dimension.spawnItem(newDisc(jukeData.disc), event.block.location); });
            };
        };
    };
});


MC.system.run(mainTick);