const lowp vec3 CUBE[8] = vec3[8](
    //Front set of points
	vec3(-1.0, -1.0, -1.0), //TL
	vec3(1.0, -1.0, -1.0), //TR
	vec3(1.0, 1.0, -1.0), //BR
	vec3(-1.0, 1.0, -1.0), //BL
	//Back set of points
	vec3(-1.0, -1.0, 1.0),//TL
	vec3(1.0, -1.0, 1.0), //TR
	vec3(1.0, 1.0, 1.0), //BR
	vec3(-1.0, 1.0, 1.0) //BL
);

vec3 rotateMat(vec3 vpos, float rotx, float roty, float rotz){
	mat3 rx = mat3(1.,0.,0.,
                                 0.,cos(rotx),-sin(rotx),
                                 0.,sin(rotx), cos(rotx));
    mat3 ry = mat3(cos(roty),0.,sin(roty),
                                 0.,1.,0.,
                                 -sin(roty),0.,cos(roty));
 /*   mat3 rz= mat3(cos(rotz),-sin(rotz),0.,
                                 sin(rotz),cos(rotz),0.,
                                 0.,0.,1.);*/
           //  res = rz*res;
    return rx*ry*vpos;
}

vec2 projPoint(vec3 opos){
	float dts = 1./(4.-opos.z);
	/*//float dts = 1.;
	mat2x3 p = mat2x3(dts,0.,0.,
                                        0.,dts,0.);
    return vec2(
        (p[0][0]*opos.x)+(p[0][1]*opos.y)+(p[0][2]*opos.z),
        (p[1][0]*opos.x)+(p[1][1]*opos.y)+(p[1][2]*opos.z)
    );*/
    return vec2(dot(opos, vec3(dts,0.,0.)), dot(opos, vec3(0.,dts,0.)));
//    projd/=map(opos.z+1.5, 1., 2., 1., 1.75);

	//return projd;
	//return opos.xy/opos.z;
}

float getTriangleArea(highp vec2 a, highp vec2 b, highp vec2 c){
    //return abs((a.x-c.x)*(b.y-a.y)-(a.x-b.x)*(c.y-a.y));
    return abs(dot(vec2(a.x-c.x, -(a.x-b.x)), vec2(b.y-a.y, c.y-a.y)));
}
bool inPoly(lowp vec2 p, lowp vec2 p1, lowp vec2 p2, lowp vec2 p3, lowp vec2 p4){
    lowp float sum = getTriangleArea(p1, p2, p)+getTriangleArea(p2, p3, p)+getTriangleArea(p3, p4, p)+getTriangleArea(p4, p1, p);
    lowp float quad = getTriangleArea(p1, p2, p3)+getTriangleArea(p3, p4, p1);
    
    // we subtract the sum by a very small number to avoid some artifacts
    return quad >= sum - 0.00001;
}
/*
#define PROJECTPOINT(j) {\
        verts[j]+=o;\
		verts[j]*=s;\
		vec3 rot = rotateMat(verts[j], rotam.x,rotam.y,rotam.z);\
		rot+=po;\
		projdp[j] = projPoint(rot)*1.5;\
}*/

float sqDistLine(vec2 p, vec2 a, vec2 b){
	vec2 ab = b-a;
	float sqrLenAB = dot(ab, ab);
	float t = clamp(dot(p-a, ab) / sqrLenAB, 0.0, 1.0);
	vec2 nearpoint = a + ab * t;
	return dot(p - nearpoint, p - nearpoint);
}

#define PROJECTPOINT(j) projdp[j] = projPoint(rotateMat(verts[j]*(s*mix(1.0, 0.9,blur))+o*(s), rotam.x,rotam.y,rotam.z)+po)*1.5;
#define MINIMUMDISTANCE(i, j) minDist = min(sqDistLine(p, projdp[i], projdp[j]), minDist);


float incube(vec2 p, vec3 rotam, vec3 o, vec3 s, vec3 po, float blur){
	lowp vec3 verts[8] = CUBE;
	
	lowp vec2 projdp[8];
	/*
	for(int j = 0; j < 8; j++){
		verts[j]+=o;
		verts[j]*=s;
		vec3 rot = rotateMat(verts[j], rotam.x,rotam.y,rotam.z);
		rot+=po;
		projdp[j] = projPoint(rot)*1.5;
	}
	*/
    PROJECTPOINT(0);
    PROJECTPOINT(1);
    PROJECTPOINT(2);
    PROJECTPOINT(3);
    PROJECTPOINT(4);
    PROJECTPOINT(5);
    PROJECTPOINT(6);
    PROJECTPOINT(7);
	/*intersects1 = intersectionTest(p, vec2(p.x+100., p.y), projdp);
	//if(intersects1 == 0.) return 0.;
    intersects2 = intersectionTest(p, vec2(p.x-100., p.y), projdp);
	return min(min(intersects1, intersects2), 1.);*/
	
    bool poly1 = inPoly(p, projdp[0], projdp[1], projdp[2], projdp[3]);
    bool poly2 = inPoly(p, projdp[4], projdp[5], projdp[6], projdp[7]);
    bool poly3 = inPoly(p, projdp[0], projdp[4], projdp[7], projdp[3]);
    bool poly4 = inPoly(p, projdp[1], projdp[5], projdp[6], projdp[2]);
    bool poly5 = inPoly(p, projdp[2], projdp[3], projdp[7], projdp[6]);
    //bool poly6 = inPoly(p, projdp[0], projdp[1], projdp[5], projdp[4]);
    
    float inCube = (poly1||poly2||poly3||poly4||poly5) ? 1.0 : 0.0;
    
    float minDist = sqDistLine(p, projdp[0], projdp[1]);
    //MINIMUMDISTANCE(0,1);
    MINIMUMDISTANCE(2,3);
    MINIMUMDISTANCE(4,5);
    MINIMUMDISTANCE(6,7);
    
    MINIMUMDISTANCE(0,3);
    MINIMUMDISTANCE(1,2);
    MINIMUMDISTANCE(4,7);
    MINIMUMDISTANCE(5,6);
    
    MINIMUMDISTANCE(0,4);
    MINIMUMDISTANCE(1,5);
    MINIMUMDISTANCE(2,6);
    MINIMUMDISTANCE(3,7);
    
    return max(inCube, 1.0-clamp(sqrt(minDist)*(64.0/(blur*8.0+1.0)), 0.0, 1.0)); 
}

float sfloor(float n){
	return floor(n) + smoothstep(0.8, 1.0, fract(n));
}

const lowp float qPi = 0.78539;
float playerShadow3d(in lowp vec3 shPos, in lowp vec2 pRot, in lowp vec3 chpos, in lowp vec3 wrldpos){
	//float shCol = 0.;
	/*if(shPos.z > -0.125 && shPos.z < 0.125 && shPos.x > 0.75 && shPos.x < 1.5){
    	  return 1.;
    }*/
	      if(wrldpos.x < 0.0) return 0.0;
		  //float an=radians(sin(((position.x-wpos.x)*2.+(position.z-wpos.z)*2.)))*45.);
		  float an=sin(2.*abs(qPi*(chpos.x-wrldpos.x))+2.*abs(qPi*(chpos.z-wrldpos.z)))*qPi;
		  //float an = sin(2.0*qPi*(abs(chpos.x-wrldpos.x)+abs(chpos.z-wrldpos.z)))*qPi;
		  float blur=smoothstep(0.0, 8.0, wrldpos.x);
		
		 
		  // a.x*b.x + a.y*b.y ...
		  //float an=sin(dot(qPi*(abs(chpos.xz-wrldpos.xz)), vec2(2.0)))*qPi;
    
	     // pr.y-=qPi*.75;*/
	    // vec2 pr = playRot;
	  //    pr.x+=.5*qPi;
    
	      lowp float cpr = (sfloor(pRot.x*2.)*.5)+(2.5*qPi);
   
         //TORSO
	     lowp float torso = incube(vec2(shPos.x-1.5, shPos.z), vec3(cpr, 0., 0.), vec3(-1.,0.,0.), vec3(0.93, 0.6, 0.31), vec3(0.),blur);
	     //if(torso == 1.) return 1.;
   
	     //LEGS
	     lowp float lleg = incube(vec2(shPos.x-1.5, shPos.z), vec3(cpr, an, 0.), vec3(-1.,1,0.), vec3(0.92, 0.31, 0.31), vec3(-1.8,0.,0.),blur);
	     lowp float rleg = incube(vec2(shPos.x-1.5, shPos.z), vec3(cpr, -an, 0.), vec3(-1.,-1.,0.), vec3(0.92, 0.31, 0.31), vec3(-1.8,0.,0.),blur);
	     //if(min(rleg, lleg) == 1.) return 1.;
	     //ARMS
	     lowp float larm = incube(vec2(shPos.x-1.5, shPos.z), vec3(cpr, an, 0.), vec3(-1.,3.,0.), vec3(0.92, 0.31, 0.31), vec3(0.,-0.1,0.),blur);
	     lowp float rarm = incube(vec2(shPos.x-1.5, shPos.z), vec3(cpr, -an, 0.), vec3(-1.,-3.,0.), vec3(0.92, 0.31, 0.31), vec3(0.,0.1,0.),blur);
	  //   if(min(rarm, larm) == 1.) return 1.;
	     
 	    //HEAD
	     lowp float head = incube(vec2(shPos.x-1.5, shPos.z), vec3(pRot.x+(2.*qPi), -(pRot.y+qPi), 0.), vec3(1.,0.,0.), vec3(0.56, 0.56, 0.56), vec3(0.),blur);
	     //diffuse.rgb -= (max(max(max(max(max(lleg,rleg), larm), rarm), torso), head)*.25)*max(map(wordShadow, 0.50, 0.05, 0., 1.), uv1.x);
	     //return min(max(lleg,rleg)+max(larm,rarm)+torso+head,1.);
	     return max(max(max(lleg, rleg), max(larm, rarm)), max(torso, head));
	    // diffuse.rgb = head;

}
