import { world, system, BlockLocation, Location } from "@minecraft/server";

const placeholder = "elevator:elevator_";

system.run(function tick() {
  system.run(tick);

  for (const player of world.getPlayers()) {
    const { dimension } = player;
    const { x, y: y2, z } = player.location;
    const block = dimension.getBlock(new BlockLocation(Math.floor(x), Math.floor(y2 - 2), Math.floor(z)));
    const { location } = block;

    if (!block.typeId.startsWith(placeholder) && !(player.isSneaking || isJumping(player))) continue;
    const newY = player.isSneaking ? location.y - 4 : isJumping(player) ? Math.floor(y2) + 6 : 0;

    for (let y = Math.min(location.y, newY); y < Math.max(location.y, newY); y++) {
      const blockInPos = dimension.getBlock(new BlockLocation(location.x, y, location.z));
      
      if (blockInPos.location.equals(block.location)) continue;
      else if (blockInPos.typeId.startsWith("elevator:elevator_")) { 
        player.isSneaking = false;
        player.teleport(new Location(Math.floor(x), Math.floor(y + 1), Math.floor(z)), dimension, 0, 0);
      }
    }
  }
});

system.events.beforeWatchdogTerminate.subscribe((evt) => {
  evt.cancel = true;
});

function isJumping(player) {
  return player.velocity.y > 0.2;
}
