#include "ShaderConstants.fxh"

struct VS_Input
{
    float3 position : POSITION;
    float4 color : COLOR;
#ifdef INSTANCEDSTEREO
	uint instanceID : SV_InstanceID;
#endif

};


struct PS_Input
{
    float4 position : SV_Position;
	float4 position2 : POS2;
	float4 position3 : POS3;
    float4 color : COLOR;
//#ifdef GEOMETRY_INSTANCEDSTEREO
#ifdef INSTANCEDSTEREO
	uint instanceID : SV_InstanceID;
#endif
//#ifdef VERTEXSHADER_INSTANCEDSTEREO
#ifdef INSTANCEDSTEREO
	uint renTarget_id : SV_RenderTargetArrayIndex;
#endif
};

//static const float fogNear = 0.9;
static const float fogNear = 0.9;

static const float3 inverseLightDirection = float3( 0.62, 0.78, 0.0 );
static const float ambient = 0.7;

ROOT_SIGNATURE
void main(in VS_Input VSInput, out PS_Input PSInput)
{
#ifdef INSTANCEDSTEREO
	int i = VSInput.instanceID;
	PSInput.position = mul( WORLDVIEWPROJ_STEREO[i], float4( VSInput.position, 1 ) );
	PSInput.position2 = mul( WORLDVIEWPROJ_STEREO[i], float4( VSInput.position+float3(5.5,7,-10.5), 1 ) );
	PSInput.position3 = mul( WORLDVIEWPROJ_STEREO[i], float4( VSInput.position+float3(-5.9,18,10.7), 1 ) );
	float3 worldPos = mul(WORLD_STEREO, float4(VSInput.position, 1));
#else
	PSInput.position = mul(WORLDVIEWPROJ, float4(VSInput.position, 1));
	PSInput.position2 = mul(WORLDVIEWPROJ, float4(VSInput.position+float3(5.5,7,-10.5), 1));
	PSInput.position3 = mul(WORLDVIEWPROJ, float4(VSInput.position+float3(-5.9,18,10.7), 1));
	float3 worldPos = mul(WORLD, float4(VSInput.position, 1));
#endif
//#ifdef GEOMETRY_INSTANCEDSTEREO
#ifdef INSTANCEDSTEREO
	PSInput.instanceID = VSInput.instanceID;
#endif 
//#ifdef VERTEXSHADER_INSTANCEDSTEREO
#ifdef INSTANCEDSTEREO
	PSInput.renTarget_id = VSInput.instanceID;
#endif
    //PSInput.color = VSInput.color * CURRENT_COLOR;
	//PSInput.color = VSInput.color *CURRENT_COLOR*(1.0+0.15*VSInput.position.y);
	//PSInput.color = CURRENT_COLOR*(0.6+0.5*VSInput.position.y);
	
	float weather = smoothstep(0.8,0.9,FOG_CONTROL.y);
	
	//cos(3.1416*VSInput.position.y)
	//PSInput.color = lerp(CURRENT_COLOR*0.4*weather+float4(0.4*FOG_COLOR.rgb,1),CURRENT_COLOR*1.1*weather,saturate(0.5*VSInput.position.y));
	//PSInput.color = lerp(CURRENT_COLOR*0.4*weather+float4(0.5*FOG_COLOR.rgb,1),CURRENT_COLOR*1.2*weather,0.5-0.5*cos(3.1416*VSInput.position.y));
	PSInput.color = lerp(CURRENT_COLOR*0.6*weather+float4(0.4*FOG_COLOR.rgb,1),CURRENT_COLOR*1.4*weather,1-cos(3.1416*0.3*VSInput.position.y));
	float depth = length(worldPos) / RENDER_DISTANCE;

    float fog = max( depth - fogNear, 0.0 );

    PSInput.color.a *= (1.0 - fog);
	//less visible in dark
	PSInput.color.a *= (1.0 - fog)*(0.1+0.2*weather+0.2*FOG_COLOR.r);
	//PSInput.color.a *= (0.1+0.5*weather+0.4*FOG_COLOR.r) -fog;
}