#include "ShaderConstants.fxh"

struct GeometryShaderInput
{
	float4		pos				: SV_POSITION;
	float4 pos2 : POS2;
	float4 pos3 : POS3;
	float4		color			: COLOR;
#ifdef INSTANCEDSTEREO
//#ifdef GEOMETRY_INSTANCEDSTEREO
	uint instanceID : SV_InstanceID;
#endif
/*
#ifdef VERTEXSHADER_INSTANCEDSTEREO
	uint renTarget_id : SV_RenderTargetArrayIndex;
#endif
*/
};

// Per-pixel color data passed through the pixel shader.
struct GeometryShaderOutput
{
	float4		pos				: SV_POSITION;
	float4 pos2 : POS2;
	float4 pos3 : POS3;
	float4		color			: COLOR;
/*
#ifdef GEOMETRY_INSTANCEDSTEREO
	uint instanceID : SV_InstanceID;
#endif
*/
#ifdef INSTANCEDSTEREO
//#ifdef VERTEXSHADER_INSTANCEDSTEREO
	uint renTarget_id : SV_RenderTargetArrayIndex;
#endif
};

// passes through the triangles, except changint the viewport id to match the instance
//[maxvertexcount(3)]
[maxvertexcount(9)]
void main(triangle GeometryShaderInput input[3], inout TriangleStream<GeometryShaderOutput> outStream)
{
	GeometryShaderOutput output = (GeometryShaderOutput)0;
	//GeometryShaderOutput output2 = (GeometryShaderOutput)0;
	//GeometryShaderOutput output3 = (GeometryShaderOutput)0;

#ifdef INSTANCEDSTEREO
//#ifdef GEOMETRY_INSTANCEDSTEREO
	int i = input[0].instanceID;
#endif

	for (int j = 0; j < 3; j++)
	{
		output.pos = input[j].pos;
		output.pos2 = input[j].pos;
		output.pos3 = input[j].pos;
		output.color = input[j].color;
		output.color = output.color;
		#ifdef INSTANCEDSTEREO
		//#ifdef VERTEXSHADER_INSTANCEDSTEREO
				output.renTarget_id = i;
		#endif
		outStream.Append(output);
	}
	outStream.RestartStrip();
	//draw MORE clouds
	for (int j = 0; j < 3; j++)
	{
		output.pos = input[j].pos2;
		output.pos2 = input[j].pos2;
		output.pos3 = input[j].pos2;
		//output2.pos = output2.pos+float4(0,90,0,0);
		output.color = input[j].color;
		output.color = output.color*float4(1,1,1,0.4);
		#ifdef INSTANCEDSTEREO
		//#ifdef VERTEXSHADER_INSTANCEDSTEREO
				output.renTarget_id = i;
		#endif
		outStream.Append(output);
	}
	
	outStream.RestartStrip();
	for (int j = 0; j < 3; j++)
	{
		output.pos = input[j].pos3;
		output.pos2 = input[j].pos3;
		output.pos3 = input[j].pos3;
		output.color = input[j].color;
		output.color = output.color*float4(1,1,1,0.1);
		#ifdef INSTANCEDSTEREO
		//#ifdef VERTEXSHADER_INSTANCEDSTEREO
				output.renTarget_id = i;
		#endif
		outStream.Append(output);
	}
}