// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "uniformShaderConstants.h"
#include "fragmentVersionSimple.h"
#include "uniformPerFrameConstants.h"

/////////////////////////////////////////////////////////////////
///////////////////////// STOP! /////////////////////////////////
/////////////////////////////////////////////////////////////////
// Made by @bamboo_sapling
// successfully changed on oct 2020.
// all of these assets are under MIT license.
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////

varying highp vec3 pos;

vec3 skycolor(in float lenpos){
	float dfog = (1.-FOG_COLOR.b)*clamp((FOG_COLOR.r-.15)*1.25,0.,1.), nfog = pow(max(min(1.0-FOG_COLOR.r*1.5,1.),.0),1.2);
	float rain = (1. - pow(FOG_CONTROL.y, 10.));

	vec3 skycolor = mix(vec3(.47,.65,.97),vec3(.2,.4,.9)*.34,nfog);
		skycolor = mix(skycolor,vec3(0,0.2,0.6),dfog);
		skycolor = mix(skycolor,FOG_COLOR.rgb*1.5,rain);

	vec3 scattercolor = mix(sqrt(FOG_COLOR.rgb),FOG_COLOR.rgb+vec3(FOG_COLOR.r,FOG_COLOR.g,FOG_COLOR.b*2.)*1.2,dfog*3.);
		scattercolor = mix(scattercolor,FOG_COLOR.rgb*1.3,rain);
		skycolor = mix(skycolor,scattercolor,smoothstep(.12,1.,lenpos*1.3));
		skycolor = mix(skycolor,FOG_COLOR.rgb,pow(lenpos*1.05,2.));

if(FOG_CONTROL.x == 0.){
return FOG_COLOR.rgb;
} else {
return skycolor;
}
}

void main(){

	highp float lp = length(pos.xz);
	vec3 result = skycolor(lp);
gl_FragColor = vec4(result, FOG_COLOR.a);

}
