#include "ShaderConstants.fxh"

struct VS_Input
{
    float3 position : POSITION;
    float2 uv : TEXCOORD_0;
#ifdef INSTANCEDSTEREO
	uint instanceID : SV_InstanceID;
#endif 
};


struct PS_Input
{
    float4 position : SV_Position;
    float2 uv : TEXCOORD_0;
    
    // --- varying
    float3 pos : POSITION;
    float2 fogControl : FOG_CONTROL;
    float4 fogColor : FOG_COLOR;
    float4 vpos : Sun_View;
    // -----------

#ifdef GEOMETRY_INSTANCEDSTEREO
	uint instanceID : SV_InstanceID;
#endif
#ifdef VERTEXSHADER_INSTANCEDSTEREO
	uint renTarget_id : SV_RenderTargetArrayIndex;
#endif
};

ROOT_SIGNATURE
void main(in VS_Input VSInput, out PS_Input PSInput)
{
	PSInput.pos = VSInput.position;
    PSInput.uv = VSInput.uv;
    float2 size = float2( 3.0, 1.0 );
    float4 pos = float4( VSInput.position, 1.0 ) * float4( size, size );

#ifdef INSTANCEDSTEREO
	int i = VSInput.instanceID;
	PSInput.position = mul( WORLDVIEWPROJ_STEREO[i], pos );
    PSInput.vpos = mul( float4(VSInput.position, 1), WORLDVIEWPROJ_STEREO[i] );
#else
	PSInput.position = mul(WORLDVIEWPROJ, pos );
    PSInput.vpos = mul( float4(VSInput.position, 1), WORLDVIEWPROJ );
#endif
#ifdef GEOMETRY_INSTANCEDSTEREO
	PSInput.instanceID = VSInput.instanceID;
#endif 
#ifdef VERTEXSHADER_INSTANCEDSTEREO
	PSInput.renTarget_id = VSInput.instanceID;
#endif
}