#include "ShaderConstants.fxh"
#include "util.fxh"

struct PS_Input
{
    float4 position : SV_Position;
    float2 uv : TEXCOORD_0_FB_MSAA;

    // --- varying
    float3 pos : POSITION;
    float2 fogControl : FOG_CONTROL;
    float4 fogColor : FOG_COLOR; 
    float4 vpos : Sun_View;
    // -----------
};

struct PS_Output
{
    float4 color : SV_Target; 
};

ROOT_SIGNATURE
#include "inc/.sky.fxh"
#include "inc/.lensflare.fxh"
void main(in PS_Input PSInput, out PS_Output PSOutput)
{
#if !defined(TEXEL_AA) || !defined(TEXEL_AA_FEATURE) || (VERSION < 0xa000 /*D3D_FEATURE_LEVEL_10_0*/) 
	float4 diffuse = TEXTURE_0.Sample(TextureSampler0, frac( PSInput.uv * 3.0 ) );
#else
	float4 diffuse = texture2D_AA(TEXTURE_0, TextureSampler0, frac( PSInput.uv * 3.0 ) );
#endif

#ifdef ALPHA_TEST
    if( diffuse.a < 0.5 )
    {
        discard;
    }
#endif

    // --- PioShader

    data deteksi;
    _deteksi( PSInput, deteksi, CURRENT_COLOR - 0.05 );
    float3 pos = PSInput.pos.xyz;
    float lp = max(0.5 -length( pos ), 0.0 );
    lp = normalize( lp ) * pow( lp, 1.5 );

    float3 scolor = float3( 0.8, 0.56, -1.0 );

    // Source Code : Zaifa Shader v4 ( sun_moon.fragment )
    // ----------------------------------------------------------------------------------
    float sm = 0.0;
    float lingkar = max(1.- pow(length(pos*25.0),9.),0.);
    if( lingkar > 0.0 ) sm = lingkar;
    // ----------------------------------------------------------------------------------

    float3 matahari; 
    // deteksi.matahari containts bugs. so, i cant use this
    //matahari.rgb = max( lp * lerp( float3( 0.6, 0.6, 0.6 ), scolor, deteksi.matahari ), float3( 0.0, 0.0, 0.0 ) );
    matahari = max( lp, float3( 0.0, 0.0, 0.0 ) );
    diffuse.rgb = lerp( float3( 0.0, 0.0, 0.0 ), diffuse.rgb, ceil( 0.18 -length( pos ) ) );

    // Lensflare
    float2 u = -PSInput.vpos.xz * .15;
    float3 c = float3( 1.4, 1.2, 1. ) * lensflare( PSInput.pos.xz * 7.5, u ) * 1.0;
    c = cc( c, 0.1, 0.1 );
    matahari += pow( c, 1.2 );
    PSOutput.color = clamp( CURRENT_COLOR * float4( lerp( matahari, diffuse.rgb, sm ), diffuse.a ), 0.0, deteksi.siang ) - 0.01;

    // -------------

#ifdef WINDOWSMR_MAGICALPHA
    // Set the magic MR value alpha value so that this content pops over layers
    PSOutput.color.a = 133.0f / 255.0f;
#endif
}
