#include "ShaderConstants.fxh"

struct VS_Input
{
    float3 position : POSITION;
    float4 color : COLOR;
#ifdef INSTANCEDSTEREO
	uint instanceID : SV_InstanceID; 
#endif
};


struct PS_Input
{
    float4 position : SV_Position;
    float4 color : COLOR;

    // --- varying
    	float3 pos : POSITION;
    	float4 ccolor : CURRENT_COLOR;
        float2 fogControl : FOG_CONTROL;
        float4 fogColor : FOG_COLOR;
        float time : TIME;
    // -----------

#ifdef GEOMETRY_INSTANCEDSTEREO
	uint instanceID : SV_InstanceID;
#endif
#ifdef VERTEXSHADER_INSTANCEDSTEREO
	uint renTarget_id : SV_RenderTargetArrayIndex;
#endif
};

ROOT_SIGNATURE
void main(in VS_Input VSInput, out PS_Input PSInput)
{
	float3 pmod = VSInput.position;
	pmod.y -= length( pmod.xyz ) * 0.15;
#ifdef INSTANCEDSTEREO
	int i = VSInput.instanceID;
	PSInput.position = mul( WORLDVIEWPROJ_STEREO[i], float4( pmod, 1 ) );
#else
	PSInput.position = mul(WORLDVIEWPROJ, float4( pmod, 1));
#endif
#ifdef GEOMETRY_INSTANCEDSTEREO
	PSInput.instanceID = VSInput.instanceID;
#endif 
#ifdef VERTEXSHADER_INSTANCEDSTEREO
	PSInput.renTarget_id = VSInput.instanceID;
#endif
    PSInput.color = lerp( CURRENT_COLOR, FOG_COLOR, VSInput.color.r );
    PSInput.pos = VSInput.position;
    PSInput.ccolor = CURRENT_COLOR;
    PSInput.fogControl = FOG_CONTROL;
    PSInput.fogColor = FOG_COLOR;
    PSInput.time = TIME;
}