#include "ShaderConstants.fxh"

struct PS_Input
{
    float4 position : SV_Position;
    float4 color : COLOR;

    // --- varying
    	float3 pos : POSITION;
    	float4 ccolor : CURRENT_COLOR;
    	float2 fogControl : FOG_CONTROL;
        float4 fogColor : FOG_COLOR;
    // -----------
};

struct PS_Output
{
    float4 color : SV_Target; 
};

ROOT_SIGNATURE
#define fragment
#include "inc/.sky.fxh"
#include "inc/settings.fxh"

#if CLOUDS
	#include "inc/.clouds.fxh"
#endif

void main(in PS_Input PSInput, out PS_Output PSOutput)
{
	// --- PioDiamond
		#define TIME ( PSInput.time * 0.5 )
		data deteksi;
		_deteksi( PSInput, deteksi, PSInput.ccolor );

		float3 fc = PSInput.fogColor.rgb;
		float lp = length( PSInput.pos );
		float sstep = smoothstep( 0.0, 1.0, lp );
		float CloudsAlpha = 0.0;
		float3 siang = lerp( float3( 0.0, 0.3, 1.0 ), float3( 0.0, 0.5, 1.0 ), pow( sstep, 0.4 ) );
		float3 malam = float3( 0.0, 0.0, 0.0 );
		float3 langit = lerp( lerp( malam, siang, deteksi.siang ), fc, deteksi.hujan );

		#if CLOUDS
			langit = lerp( langit, float3( 1.0, 1.0, 1.0 ), ( clouds( PSInput.pos.zx, deteksi ) ) * max( deteksi.siang, 0.3 ) );
			if ( langit.b > 0.0 ) CloudsAlpha = 1.0; 
		#endif

		float4 color = float4( lerp( langit, fc, pow( sstep, 0.6 ) ), CloudsAlpha );
	// --------------


    PSOutput.color = color;
}