#include "ShaderConstants.fxh"
#include "util.fxh"

struct PS_Input
{
	float4 position : SV_Position;

	// --- varying
	float4 fogColor : FOG_COLOR;
	float2 fogControl : FOG_CONTROL;
	float3 pos : POSITION;
	float3 worldPos : worldPos;
	// -----------

#ifndef BYPASS_PIXEL_SHADER
	float4 color : COLOR;
	snorm float2 uv0 : TEXCOORD_0_FB_MSAA;
	snorm float2 uv1 : TEXCOORD_1_FB_MSAA;
#endif
};

struct PS_Output
{
	float4 color : SV_Target;
};

ROOT_SIGNATURE

// --- PioShader
	#define fragment
	#include "inc/settings.fxh"
	#include "inc/.noise.fxh"
	#include "inc/.render.fxh"
	#include "inc/.color.fxh"
	#include "inc/.caustic.fxh"
	#include "inc/.rain.fxh"
// -------------

void main(in PS_Input PSInput, out PS_Output PSOutput)
{

// optimize shader ( Created by PioDiamond )
// I dont know it is working or not.
if( _distance( PSInput, 1.11 ) >= 1.0 ) {
  discard;
}
// -----------------------------------------

#ifdef BYPASS_PIXEL_SHADER
    PSOutput.color = float4(0.0f, 0.0f, 0.0f, 0.0f);
    return;
#else

    float4 df;
    float4 diffuse;
	bool Is_Water = is_water( PSInput );

if ( Is_Water ){

	df = diffuse = PSInput.color;

#if USE_ALPHA_TEST
	#ifdef ALPHA_TO_COVERAGE
		#define ALPHA_THRESHOLD 0.05
	#else
		#define ALPHA_THRESHOLD 0.5
	#endif
	if(diffuse.a < ALPHA_THRESHOLD)
		discard;
#endif

} else {

#if USE_TEXEL_AA
	diffuse = texture2D_AA(TEXTURE_0, TextureSampler0, PSInput.uv0 );
#else
	diffuse = TEXTURE_0.Sample(TextureSampler0, PSInput.uv0);
#endif
	df = diffuse;

#ifdef SEASONS_FAR
	diffuse.a = 1.0f;
#endif

#if USE_ALPHA_TEST
	#ifdef ALPHA_TO_COVERAGE
		#define ALPHA_THRESHOLD 0.05
	#else
		#define ALPHA_THRESHOLD 0.5
	#endif
	if(diffuse.a < ALPHA_THRESHOLD)
		discard;
#endif

#if defined(BLEND)
	diffuse.a *= PSInput.color.a;
#endif

#ifndef SEASONS
	#if !USE_ALPHA_TEST && !defined(BLEND)
		diffuse.a = PSInput.color.a;
	#endif	

	diffuse.rgb *= PSInput.color.rgb;
#else
	float2 uv = PSInput.color.xy;
	diffuse.rgb *= lerp(1.0f, TEXTURE_2.Sample(TextureSampler2, uv).rgb*2.0f, PSInput.color.b);
	diffuse.rgb *= PSInput.color.aaa;
	diffuse.a = 1.0f;
#endif

	setColor( diffuse.rgb );
} // Is_Water


// --- PioShader

	data deteksi;
	_deteksi( PSInput, deteksi );

	//siang
	float3 siang = diffuse.rgb;

	//sore
	float3 sore = lerp( float3( 0.0, 0.0, 0.0 ), float3( 0.4, 0.2, -0.05 ), length( diffuse.rgb ) ) + diffuse.rgb;

	//malam
	float3 malam = diffuse.rgb * 0.65;

	//hujan
	float3 hujan = saturation( diffuse.rgb, 0.5 );

	//dalam air
	float underwater_ = max( deteksi.siang, 0.6 );

	//set light
	sore = lerp( siang, sore, min( 0.5 - abs( deteksi.siang - 0.5 ),  1.0) * 2.0 * ( 1.0 - deteksi.hujan ) );
	diffuse.rgb = lerp( malam, sore, deteksi.siang );
	diffuse.rgb = lerp( diffuse.rgb, hujan, deteksi.hujan * PSInput.uv1.y ) * lerp( 1.0, 0.6, deteksi.siang * deteksi.hujan );

	#if WATER_WAVES
		if ( Is_Water ){
		  water_color( PSInput, diffuse );
		}
	#endif

	float3 sblock = _shadowblock( PSInput, deteksi, diffuse.rgb );
	#if BLOCK_SHADOW
	  diffuse.rgb = sblock;
	#endif

	#ifndef FOG_UNDERWATER
		#if GRASS_SHADOW
		  diffuse.rgb = lerp( diffuse.rgb, _grass( PSInput, deteksi, diffuse.rgb ), sblock );
		#endif

		#if SUN_REFLECTION
		   sun( PSInput, deteksi, diffuse,  Is_Water );
		#endif

		#if CLOUDS_REFLECTION && !defined( ALPHA_TEST )
		if ( Is_Water || ( diffuse.a < 0.95 && PSInput.color.a > 0.0 && frac( PSInput.pos.y ) == 0.0 ) ){
		   float skala = Is_Water ? sin( diffuse.g ) : 0.4;
		   float4 awan;
		   awan.rgb = clouds( ( PSInput.worldPos.zx * skala ) * 0.04, deteksi ) * 0.22;
		   awan.a = Is_Water ? -0.035 : awan.b * 3.0;
		   diffuse += awan * ( max( PSInput.uv1.y - 0.1, 0.0 ) ) * max( deteksi.siang, 0.3 );
		}
		#endif

		#if DIRLIGHT
			if ( frac( PSInput.pos.x ) == 0.0 )
				diffuse.rgb *= lerp( 0.9, 0.7, PSInput.uv1.y * ( 1.0 - PSInput.uv1.x ) * deteksi.siang );
		#endif

		#if RAIN_SPLASH
			if( deteksi.hujan > 0.4 ) diffuse.rgb += rain( PSInput ) * deteksi.hujan;
		#endif

	#else

		diffuse.rgb *= underwater_;
		if ( Is_Water == false )
			diffuse.rgb += caustic( PSInput, deteksi );

	#endif

	_lightset( PSInput, deteksi, diffuse, length( df.rgb ) );
	_fog( PSInput, diffuse.rgb );

// -------------

	PSOutput.color = diffuse;

#ifdef VR_MODE
	// On Rift, the transition from 0 brightness to the lowest 8 bit value is abrupt, so clamp to 
	// the lowest 8 bit value.
	PSOutput.color = max(PSOutput.color, 1 / 255.0f);
#endif

#endif // BYPASS_PIXEL_SHADER
}