
/*
// Noise Source : https://gist.github.com/patriciogonzalezvivo/670c22f3966e662d2f83
// ----------------------------------------------------------------------------------
float hash( float2 p ) { return frac(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs( sin( p.y * 13.0 + p.x )))); }
float noise( in float2 x ) {
	float2 i = floor(x);
	float2 f = frac(x);
	float a = hash(i);
	float b = hash(i + float2(1.0, 0.0));
	float c = hash(i + float2(0.0, 1.0));
	float d = hash(i + float2(1.0, 1.0));
	float2 u = f * f * (3.0 - 2.0 * f);
	return lerp(a, b, u.x) + (c - a) * u.y * (1.0 - u.x) + (d - b) * u.x * u.y;
}
// ----------------------------------------------------------------------------------
*/

// Noise Source : https://www.shadertoy.com/view/tstXzS
float random(float2 co)
{
    float a = 12.9898;
    float b = 78.233;
    float c = 43758.5453;
    float dt= dot(co.xy, float2(a,b));
    float sn= fmod(dt,3.14);
    return frac(sin(sn) * c);
}

float noise(in float2 st) {
    float2 i = floor(st);
    float2 f = frac(st);

    float a = random(i);
    float b = random(i + float2(1.0, 0.0));
    float c = random(i + float2(0.0, 1.0));
    float d = random(i + float2(1.0, 1.0));

    float2 u = f * f * (3.0 - 2.0 * f);

    return lerp(a, b, u.x) +
            (c - a)* u.y * (1.0 - u.x) +
            (d - b) * u.x * u.y;
}
// -----------------------------------------------------
