#include "ShaderConstants.fxh"
#include "util.fxh"

struct PS_Input
{
    float4 position : SV_Position;
    float2 uv : TEXCOORD_0_FB_MSAA;
};

struct PS_Output
{
    float4 color : SV_Target;
};

ROOT_SIGNATURE
#include "inc/settings.fxh"
void main(in PS_Input PSInput, out PS_Output PSOutput)
{
#if CLOUDS
	discard;
#else
	#if !defined(TEXEL_AA) || !defined(TEXEL_AA_FEATURE) || (VERSION < 0xa000 /*D3D_FEATURE_LEVEL_10_0*/) 
		float4 diffuse = TEXTURE_0.Sample(TextureSampler0, PSInput.uv);
	#else
		float4 diffuse = texture2D_AA(TEXTURE_0, TextureSampler0, PSInput.uv);
	#endif

	#ifdef ALPHA_TEST
	    if( diffuse.a < 0.5 )
	    {
	        discard;
	    }
	#endif

	#ifdef IGNORE_CURRENTCOLOR
	    PSOutput.color = diffuse;
	#else
	    PSOutput.color = CURRENT_COLOR * diffuse;
	#endif

	#ifdef WINDOWSMR_MAGICALPHA
	    // Set the magic MR value alpha value so that this content pops over layers
	    PSOutput.color.a = 133.0f / 255.0f;
	#endif
#endif
}
