// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "fragmentVersionSimple.h"
#include "uniformPerFrameConstants.h"

varying vec4 color;
varying vec3 pos;
varying vec4 ccolor;
varying vec2 fogControl;
varying vec4 fogColor;

#define fragment
#include "inc/.hlsl2glsl.h"
#include "inc/.sky.h"
#include "inc/settings.h"

#if CLOUDS
  #include "inc/.clouds.h"
#endif

void main()
{
	// --- PioDiamond
		#define TIMER ( TIME * 0.5 )
		data deteksi;
		_deteksi( deteksi, ccolor );

		float3 fc = fogColor.rgb;
		float lp = length( pos );
		float sstep = smoothstep( 0.0, 1.0, lp );
		float CloudsAlpha = 0.0;
		float3 siang = lerp( float3( 0.0, 0.3, 1.0 ), float3( 0.0, 0.5, 1.0 ), pow( sstep, 0.4 ) );
		float3 malam = float3( 0.0, 0.0, 0.0 );
		float3 langit = lerp( lerp( malam, siang, deteksi.siang ), fc, deteksi.hujan );

		#if CLOUDS
			langit = lerp( langit, float3( 1.0, 1.0, 1.0 ), ( clouds( pos.zx, deteksi ) ) * max( deteksi.siang, 0.3 ) );
			if ( langit.b > 0.0 ) CloudsAlpha = 1.0; 
		#endif

		float4 color = float4( lerp( langit, fc, pow( sstep, 0.6 ) ), CloudsAlpha );
	// --------------

	gl_FragColor = color;
}