// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "fragmentVersionCentroid.h"

#if __VERSION__ >= 300
	#ifndef BYPASS_PIXEL_SHADER
		#if defined(TEXEL_AA) && defined(TEXEL_AA_FEATURE)
			_centroid in highp vec2 uv0;
			_centroid in highp vec2 uv1;
		#else
			_centroid in vec2 uv0;
			_centroid in vec2 uv1;
		#endif
	#endif
#else
	#ifndef BYPASS_PIXEL_SHADER
		varying vec2 uv0;
		varying vec2 uv1;
	#endif
#endif

varying vec4 color;
varying vec4 fogColor;
varying vec2 fogControl;
varying highp vec3 pos;
varying vec4 worldPos;

#include "uniformShaderConstants.h"
#include "uniformPerFrameConstants.h"
#include "util.h"

LAYOUT_BINDING(0) uniform sampler2D TEXTURE_0;
LAYOUT_BINDING(1) uniform sampler2D TEXTURE_1;
LAYOUT_BINDING(2) uniform sampler2D TEXTURE_2;

// --- PioShader
	#define fragment
	#include "inc/settings.h"
 	#include "inc/.hlsl2glsl.h"
	#include "inc/.noise.h"
	#include "inc/.render.h"
	#include "inc/.color.h"
	#include "inc/.caustic.h"
	#include "inc/.rain.h"
// -------------

void main()
{
#ifdef BYPASS_PIXEL_SHADER
	gl_FragColor = vec4(0, 0, 0, 0);
	return;
#else 

// optimize shader ( Created by PioDiamond )
// I dont know it is working or not.
if( _distance( 1.11 ) >= 1.0 ) {
  discard;
}
// -----------------------------------------

  float4 df;
  float4 diffuse;
	bool Is_Water = is_water();

if ( Is_Water ){

	df = diffuse = color;

#if USE_ALPHA_TEST
	#ifdef ALPHA_TO_COVERAGE
		#define ALPHA_THRESHOLD 0.05
	#else
		#define ALPHA_THRESHOLD 0.5
	#endif
	if(diffuse.a < ALPHA_THRESHOLD)
		discard;
#endif

} else {

#if USE_TEXEL_AA
	diffuse = texture2D_AA(TEXTURE_0, uv0);
#else
	diffuse = texture2D(TEXTURE_0, uv0);
#endif
	
df = diffuse;

#ifdef SEASONS_FAR
	diffuse.a = 1.0;
#endif

#if USE_ALPHA_TEST
	#ifdef ALPHA_TO_COVERAGE
	#define ALPHA_THRESHOLD 0.05
	#else
	#define ALPHA_THRESHOLD 0.5
	#endif
	if(diffuse.a < ALPHA_THRESHOLD)
		discard;
#endif
	
vec4 inColor = color;

#if defined(BLEND)
	diffuse.a *= inColor.a;
#endif

#ifndef SEASONS
	#if !USE_ALPHA_TEST && !defined(BLEND)
		diffuse.a = inColor.a;
	#endif
	
	diffuse.rgb *= inColor.rgb;
#else
	vec2 uv = inColor.xy;
	diffuse.rgb *= mix(vec3(1.0,1.0,1.0), texture2D( TEXTURE_2, uv).rgb*2.0, inColor.b);
	diffuse.rgb *= inColor.aaa;
	diffuse.a = 1.0;
#endif

  setColor( diffuse.rgb );
} // Is_Water

// --- PioShader

	data deteksi;
	_deteksi( deteksi );

	//siang
	float3 siang = diffuse.rgb;

	//sore
	float3 sore = lerp( float3( 0.0, 0.0, 0.0 ), float3( 0.4, 0.2, -0.05 ), length( diffuse.rgb ) ) + diffuse.rgb;

	//malam
	float3 malam = diffuse.rgb * 0.65;

	//hujan
	float3 hujan = saturation( diffuse.rgb, 0.5 );

	//dalam air
	float underwater_ = max( deteksi.siang, 0.6 );

	//set light
	sore = lerp( siang, sore, min( 0.5 - abs( deteksi.siang - 0.5 ),  1.0) * 2.0 * ( 1.0 - deteksi.hujan ) );
	diffuse.rgb = lerp( malam, sore, deteksi.siang );
	diffuse.rgb = lerp( diffuse.rgb, hujan, deteksi.hujan * uv1.y ) * lerp( 1.0, 0.6, deteksi.siang * deteksi.hujan );

	float3 sblock = _shadowblock( deteksi, diffuse.rgb );
	#if BLOCK_SHADOW
	  diffuse.rgb = sblock;
	#endif

	#ifndef FOG_UNDERWATER
		#if GRASS_SHADOW
		  diffuse.rgb = lerp( diffuse.rgb, _grass( deteksi, diffuse.rgb ), sblock );
		#endif

		#if DIRLIGHT
			if ( frac( pos.x ) == 0.0 )
				diffuse.rgb *= lerp( 0.9, 0.7, uv1.y * ( 1.0 - uv1.x ) );
		#endif

    
		#if RAIN_SPLASH
			//if( deteksi.hujan > 0.4 ) diffuse.rgb += rain() * deteksi.hujan;
		#endif

     #else

		diffuse.rgb *= underwater_;
		if ( Is_Water == false )
			diffuse.rgb += caustic( deteksi );

	#endif

	_lightset( deteksi, diffuse, length( df.rgb ) );
	_fog( diffuse.rgb );

// -------------

	gl_FragColor = diffuse;
	
#endif // BYPASS_PIXEL_SHADER
}
