

#ifdef fragment

#define torch_strong 1.3
#define torch_color float3( 0.3, 0.15, -1.0 )
#define torch_underwater float3( 0.0, 0.5, 1.0 )
#define sun_color float4( 1.0, 0.5, 0.0, 1.0 )

struct data {
 float gelap;
 float hujan;
 float siang;
 float pagi;
 float shadow;
};

#include "inc/.clouds.h"

float _pagi( float s ){
	float awal = 0.45; // 1.0 - 0.55; 1.0 = siang
	float rentang = 1.0 / ( 1.0 - awal );
	s = max( s - awal, 0.0 );
	s *= rentang;//( 1.0 / rentang );
	s = ( 0.5 - abs( s - 0.5 ) ) * 2.0;
	return s;
}

void _deteksi( inout data deteksi ){
	deteksi.siang = clamp( max( texture2D( TEXTURE_1, float2( 0.0, 1.0 )).r - 0.5, 0.0 ) * 2.0, 0.0, 1.0 );
	deteksi.pagi = _pagi( deteksi.siang );
	deteksi.hujan = 1.0 - pow( fogControl.y, 5.0 );
	deteksi.gelap = 1.0 - max( min( max( uv1.y - 0.8, 0.0 ) * 5.0, deteksi.siang ), 0.0 );
	deteksi.shadow = deteksi.gelap * deteksi.siang;
}

float _distance( in float jarak ) {
  return clamp( length( worldPos ) / RENDER_DISTANCE * jarak, 0.0, 1.0 );
}

void wNoise( float2 uv, out float n ){
    float skala = 2.7;
    float cepat = ( -TIME * 0.5 );
    
    // float2x2 m = float2x2( 0.7, 0.7, -0.7, 0.7 );
    // float2 pos =  cepat + skala * mul( float2( uv.x * 0.3, uv.y ), m );
    
    float2x2 m = float2x2( 1.6, 1.2, 1.2, 1.6 );
    float2 pos = skala * mul( float2( uv.x * 1.5 + cepat * 0.125, uv.y + cepat ), m );
    float n1 = max( noise( pos ), 0.0 );
    float n2 = max( noise( pos - 0.1 ) * 0.9, 0.0 );
    float n3 = max( ( noise( cepat * 1.5 - pos ) - 0. ), 0.5 );
    n = clamp( ( n2 - n1 ) * n3, -0.1, 1.0 );
}

void water_color( inout float4 c ){
  float view = _distance( 2.0 );

  if ( view > 0.0 ){
    float2 uv = float2( pos.x + pos.y, pos.z ); 
    float n1;
    float n2;
    float n;
    wNoise( uv, n1 );
    wNoise( -uv * 1.875, n2 );
    
    n = lerp( n1, n2, n1 * n2 );

    // n = lerp( -0.01, 1.0, n1 );
    // n = lerp( n, 0.0, view );
	
	c.rgb += n;
    c.a = max( n, c.a ) + view;
  }
}

float3 _shadowblock( in data deteksi, in float3 c ){
if( frac( pos.y ) != 0.5 && color.r != color.b && color.r != color.g ){
   float shadow = clamp( ( uv1.y - 0.9 ) * 10.0, 0.0, 1.0 );
   c *= lerp( 1.0, max( shadow, 0.45 ), deteksi.shadow );
}else{
   float shadow = clamp( ( uv1.y - 0.9 ) * 10.0, 0.0, 1.0 );
   c *= lerp( 1.0, max( shadow, 0.7 ), deteksi.shadow );
}
  return c;
}

float3 _grass( in data deteksi, in float3 diffuse ){
	#ifdef ALPHA_TEST
    if( color.g > color.b ){
    	diffuse.rgb *= 0.8;
		}
	#endif
  return diffuse;
}

void _lightset( in data deteksi, inout float4 diffuse, float df ){
  #if !defined(ALWAYS_LIT) 
    float2 uvm = uv1;
    
    #if TORCH_COLOR
      float3 torch_;
      #ifdef FOG_UNDERWATER
        torch_ = pow( uvm.x, torch_strong ) * torch_underwater;
        torch_ = clamp( torch_, 0.0, 1.0 );
      #else
        torch_ = pow( uvm.x * max( df, 0.28 ) * ( 1.0 - deteksi.gelap ), torch_strong ) * torch_color;
        torch_ = clamp( torch_, 0.0, 1.0 );
      #endif
      diffuse *= texture2D( TEXTURE_1, uvm );
      diffuse.rgb += torch_;
    #else
      diffuse *= texture2D( TEXTURE_1, uvm );
      diffuse += max( uvm.x - 0.5, 0.0 ) * ( 1.0 - uv1.y );
    #endif
  #endif
}

void _fog( inout float3 diffuse ) {
   float dist;

#ifndef FOG_UNDERWATER
   dist = pow( _distance( 1.1 ), 11.0 );
   if( dist > 0.0 ){
	   diffuse = lerp( diffuse, fogColor.rgb, dist );
   }
#else
  dist = _distance( 2.0 );
   if( dist > 0.0 ){
     float3 fog = fogColor.rgb;
	   diffuse = lerp( diffuse, fog, dist );
   }
#endif
}

float wEffect()
{
float3 np = normalize(worldPos.xyz);
float sun = (.6-length(np.yz));
float f1pos = smoothstep(7.5 + abs(np.y)*2.0,0.0,abs(np.z)*.9);
float3 Pos = float3( f1pos, f1pos, f1pos );
float f1fr = max(0.0,sun);
float3 flatRange = float3( f1fr, f1fr, f1fr );
float specularFlat = max(dot(Pos, flatRange), 0.0);
return specularFlat * min( 1.0, 1.0 - uv1.x );
}

void sun( in data deteksi, inout float4 c, bool water ){ // 1
	float h = ( 0.0 );
	bool kena = ( frac( pos.y ) == 0.0 || frac( pos.y ) == 0.5 ) && color.r == color.g 
		&& color.r == color.b;
	float hujan = ( deteksi.hujan - 0.9 ) * 3.0;

	if ( deteksi.hujan > 0.9 ){ // 2
		if ( kena && worldPos.y <= 0.25 ){ // 3
			h += _distance( 9.0 ) * uv1.y * hujan;
			c += h;
		} // 3
	} // 2

	else if ( ( water || kena ) && worldPos.y <= 0.25 ){ // 2
		h = wEffect() * deteksi.pagi * uv1.y * min( 1.0 - hujan, 0.4 );

		if ( h > 0.0 ) { // 3
			if ( water ){ // 4
				c += lerp( float4( 0.0, 0.0, 0.0, 0.0 ), sun_color, h ) * length( c.rgb );
			} // 4
			else { // 4
				c += lerp( float4( 0.0, 0.0, 0.0, 0.0 ), sun_color , h );
			} // 4
		} // 3
	} // 2
} // 1
// ----------------------------------------------------------------------------------

void P_refect( inout float3 diffuse, in float3 df ) {
	diffuse = diffuse;
}
#endif


bool is_water(){
 bool water = false;
 #ifndef SEASONS
   if ( color.b > color.r * 1.0002 ){
     water = true;
    }
 #endif
 return water;
}