




//#ifdef fragment
  #define rotate(x) float2x2(cos( x ), -sin( x ), sin( x ), cos( x ))

// "Clouds" Created by PioDiamond
// ----------------------------------------------------------------------------------
float3 clouds( float2 p, data deteksi ) {
  float skala = 3.0;
  float cepat = 0.07;
  float waktu = ( cepat * TIME );
  const int ulang = 6;

    float2 uv;
    float2 pos;
    uv = pos = ( p.xy * skala );
    pos.x *= 0.6;
    pos *= skala;
    float d = 1.0;
    float2x2 m = rotate( 90.0 ) / 2.0;
    float cloud_base = noise( mul( m, pos ) ) * 0.5;
    float cloud = noise( mul( m, float2( pos.x - waktu, pos.y ) ) );
    for( int i = 0; i < ulang; i++ ){
        pos *= 3.5;
        pos.x += waktu * 0.1 * pow( d, 0.5 );
        d *= 2.0;
        cloud += noise( mul( m, pos ) ) / d;
    }

    cloud = ( pow( cloud, 10.0 ) * -3.0 );
    cloud = max( cloud + 1.0, 0.0 );

    cloud = (cloud > 0.0) ? ( 1.0 - abs( 0.8 - cloud ) ) : 0.0;
    float clouds_ =  lerp( max( cloud, cloud_base ), cloud_base, deteksi.hujan );
    //float clouds_ =  max( cloud, cloud_base );
    return clamp( float3( clouds_, clouds_, clouds_), 0.0, 1.0 );
}
// ----------------------------------------------------------------------------------

//#endif
